<?php
   /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    *
    */

    include "../include/util.php";
    include "../include/costanti.php";
    include "../gUtil/DbManager.php";
    include "../classi/MessaggioChat.php";
    
    session_start();
    controlloAccessoAdmin();
    
    //i dati del database sono definiti nel file costanti.php
    $geecomDb     = new DbManager($costantiDatabase);
    $impostazioni = recuperaImpostazioni($geecomDb);
    
    if(isset($_GET["operazione"])) {
        $operazione 	= filter_input(INPUT_GET,"operazione",FILTER_SANITIZE_STRING);
        $messaggioChat = new MessaggioChat($geecomDb, filter_input(INPUT_GET, "id"));
    }
    else {
        $operazione 	= filter_input(INPUT_POST,"operazione",FILTER_SANITIZE_STRING);
        $messaggioChat = new MessaggioChat($geecomDb, filter_input(INPUT_POST, "id"));
    }
    
    switch ($operazione) {
        case 'crea':
            $messaggioChat->setIdDocumento(filter_input(INPUT_POST,"idDocumento",FILTER_SANITIZE_NUMBER_INT));
            $messaggioChat->setIdUtente($_SESSION["geecomAdmin_id"]);
            $messaggioChat->setTesto(filter_input(INPUT_POST,"testo",FILTER_SANITIZE_ADD_SLASHES));
            
            $idMessaggio = $messaggioChat->crea();
            echo "ok";
            break;
        case 'modifica':
            break;
        case 'elimina':
            break;
	case 'stampaChatDocumento':
            stampaMessaggiChat($geecomDb,filter_input(INPUT_POST,"idDocumento",FILTER_SANITIZE_NUMBER_INT),$_SESSION["geecomAdmin_id"]);
            break;
    }